  ' -----------------------------------------------------------
  ' Program for Micromite to communicate with the Elecrow CT0007MS
  ' moisture sensor module.
  ' Written by Jim Rowe for Silicon Chip.
  ' Last revision 4/08/2017 at 1:15 pm
  ' ----------------------------------------------------------
  
  OPTION AUTORUN ON
  OPTION EXPLICIT
  
  DIM AS INTEGER SenValue = 0      ' variable to store the sensor output
   
  Const DBlue = RGB(0,0,128)
  CONST Bone = RGB(255,255,192)
  CONST White = RGB(WHITE)
  CONST Black = RGB(BLACK)
  CONST Red = RGB(RED)
  CONST Green = RGB(GREEN)
  
  SETPIN 24, AIN          ' declare pin 16 an input (for module o/p)
    
  ' -----------------------------------------------------------------
  ' main program loop starts here
  CLS Black   ' now show opening screen on LCD
  RBOX 0,0, MM.HRes-2, MM.VRes-2, 5, RGB(Cyan), DBlue
  TEXT MM.HRes/2, MM.VRes/8, "SILICON CHIP", CM, 1, 3, Red, DBlue
  TEXT MM.HRes/2, MM.VRes*5/16, "Elecrow CT0007MS moisture", CM, 1, 1, White, DBlue
  TEXT MM.HRes/2, MM.VRes*3/8, "sensor module checker", CM, 1, 1, White, DBlue
  TEXT 6, MM.VRes*7/8, "DRY", LM, 1,2, Green, DBlue
  TEXT MM.HRes-6, MM.VRes*7/8, "VERY WET", RM, 1,2, Green, DBlue

  DO
    RBOX 4, MM.VRes*9/16, MM.HRes-10, MM.VRes/4-6, 8, Red, Black ' show prog box
    SenValue = (PIN(24)*100)/3.0  'get sensor's output as a percentage of 3.0V
    PRINT "Moisture Value = ", SenValue, " %"      ' print it out via console
    ' then draw a 'progress bar' with its length
    BOX 10, MM.VRes*5/8, (MM.HRes-20)*SenValue/100, 25,1, Green, Green
    PAUSE 2000          ' pause for looping once every 2 seconds
  LOOP
END ' end of program
  
  ' ----------------------------------------------------------------
  
